/*---------------------------  vector  ----------------------------------*
 *                                                                       *
 * vector class:  a vector of scalars (vector.c)                         *
 *                                                                       *
 *  Also used (or shall we say mainly used) as FFT-boxes                 *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: vector.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_VECTOR_H
#define DFT_VECTOR_H

class vector
{
  /* data */
public:
  int n;
  scalar *c;
  Basis *basis;

  /* Constructors and destructor */
  vector();
  vector(int len);
  vector(int len,Basis *b);
  vector(const vector &v1); /* copy constructor */
  ~vector();
  
  /* Operators */
  void operator=(const vector &v1); /* Non-standard: assignment returns void */
  vector operator+(const vector &v1);                                     
  void operator+=(const vector &v1);                                     
  vector operator-(const vector &v1);
  void operator-=(const vector &v1);                                     
  vector operator*(scalar s);
  friend vector operator*(scalar s,const vector &v);
  void operator*=(scalar s);
  scalar operator^(const vector &v1);
  /* v^v1 is vector dotproduct where ^ is conjugate transpose */

  /* Member functions: */
  /* Does what the constructor does */
  void init(int len,Basis *b);
  /* free up memory */
  void freemem(void);
  /* Binary read/write of vector to/from fname */
  // to fully comply with MPI standard, read and  write also need to be
  // parallelized.
  void write(char *fname);
  void write(FILE *filep);
  void read(char *fname);
  void read(FILE *filep);
  /* Writes real part of vector to fname */
  void write_real(char *fname);
  void write_real(FILE *filep);
  /* Zero out the elements of the vector */
  void zero_out(void);
};

/* Euclidean square norm and length, summing a vector,
 * and pointwise multiplication of vectors */
real abs2(const vector &v);
real abs(const vector &v);
scalar sum_vector(const vector &v);
vector pointwise_mult(const vector &a,const vector &b);


#endif // DFT_VECTOR_H
