/*--------------------------- timer.c -----------------------------------*
 *                                                                       *
 *           Timing utilities                                            *
 * the access to the timers are currently                                *
 * using global variables in file timer.c.                               *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: timer.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_TIMER_H
#define DFT_TIMER_H

#ifdef DFT_PROFILING 

int timerOn(int timer);
int timerOff(int timer);
int timerSetState(int timer, int state);
void timerInitAll(void);
void timerInit(int timer, char* title);
void timerInit(int timer);
int timerReset(int timer);
double timerRead(int timer);
char* timerGetTitle(int timer);
int timerGetTotal(void);

int timerActivateAll(void);
int timerReport(int iter);

/*          Counter utilities                  */
// Keep track of access counts and other stuffs
// like memory usuage.
void counterInitAll(void);
void counterInit(int counter, char* title);
void counterIncr(int counter);
void counterIncr(int counter, double amount);
double counterRead(int counter);
char* counterGetTitle(int counter);
int counterGetTotal(void);

int timer_counter_Report();

#endif // DFT_PROFILING 

#endif // DFT_TIMER_H
