/*-----------------------  setup_ions.c  --------------------------------*
 *                                                                       *
 * Read ionic infomation from a file and setup the data structures for   *
 * the local and non-local pseudopotentials                              *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: setup_ions.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_SETUP_IONS_H
#define DFT_SETUP_IONS_H

void setup_ioninfo(Basis *basis, Ioninfo *ioninfo,char *ionsfilename,
		   Elecinfo *elecinfo);
void free_ioninfo(Ioninfo *ioninfo);
void read_dft_psp(Speciesinfo *sp_info, char *potfilename);
void read_fhi_psp(Speciesinfo *sp_info, char *potfilename, char lmax, char lloc, 
		  int ngrid_loc, real dq_loc, int ngrid_nl, real dq_nl);

#endif // DFT_SETUP_IONS_H
