/****************************************************************************
 *
 * DFT++:  density functional package developed by
 *         the research group of Prof. Tomas Arias, MIT.
 *
 * Principal author: Sohrab Ismail-Beigi
 *
 * Modifications for MPI version: Kenneth P Esler,
 *                                Sohrab Ismail-Beigi, and
 *                                Tairan Wang.
 *
 * Modifications for LSD version: Jason A Cline
 *
 * Modifications for lattice/Pulay forces: Gabor Csanyi and
 *                                         Sohrab Ismail-Beigi
 *
 * Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
 *
 ****************************************************************************/

/*
 * rnd.c:          Sohrab Ismail-Beigi             Aug. 1996
 *
 * A simple set of routines to do some random number stuff.
 * They assume the existence of a uniform deviate rnd().
 * In the current implimentation, this is done by using the system
 * random number generator random().  seed_with_time() seeds this
 * generator with the current time() value.  gauss(std) returns
 * a gaussian random variable (using rnd()) with standard deviation std.
 *
 * void seed_with_time()
 * real gauss()
 * 
 */

/*
 *  Tairan Wang                       Jun, 1999
 *
 *  seed_with_time() is moved to the System class so that 
 * we can deal with parallel objects and serial objects tranparently.
 */

/* $Id: rnd.c,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#include <math.h>
#include <time.h>
#include "header.h"


/* Uses a uniform deviate (double) random number generator rnd()
 * to return a gaussian destributed value with standard deviation std */
real
gauss(real std)
{
  static int iset=0;
  static double gset;
  real v1,v2,f,w;

  if (iset==0) /* See Chapter 7 Section 2 of Numerical Recipies */
    {
      do {
	v1 = 2.0*rnd()-1.0;
	v2 = 2.0*rnd()-1.0;
	w = v1*v1+v2*v2;
      } while (w>=1.0 || w==0.0);
      f = sqrt((double)(-2.0*log((double)w)/w));
      gset = v2*f*std;
      iset = 1;
      return v1*f*std;
    }
  else  /* return the second value we computed in the last call */
    {
      iset = 0;
      return gset;
    }
}

