/****************************************************************************
 *
 * DFT++:  density functional package developed by
 *         the research group of Prof. Tomas Arias, MIT.
 *
 * Principal author: Sohrab Ismail-Beigi
 *
 * Modifications for MPI version: Kenneth P Esler,
 *                                Sohrab Ismail-Beigi, and
 *                                Tairan Wang.
 *
 * Modifications for LSD version: Jason A Cline
 *
 * Modifications for lattice/Pulay forces: Gabor Csanyi and
 *                                         Sohrab Ismail-Beigi
 *
 * Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
 *
 ****************************************************************************/

/*
 * Sohrab Ismail-Beigi, June 12 1997
 *
 */

/* $Id: pasteempties.c,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#include <math.h>
#include <stdio.h>
#include <string.h>
/* My header file */
#include "header.h"

#define REPORT_LEVEL 1

int
main(int argc,char**argv)
{
  Basis *basis;
  Elecinfo elecinfo;   /* Electronic state information */
  Control cntrl;       /* Holds convergence control data */

  /* various other local vars */
  FILE *Cfilledfile,*Cemptyfile,*Ccombinedfile;
  char *latfilename,*elecfilename,*Cfilled_filename,*Cempty_filename,
       *Ccombined_filename,line[100];
  int nbands_empty;

  /* Read input file for information */
  if (argc == 7)
    {
      latfilename  = argv[1];
      elecfilename  = argv[2];
      sscanf(argv[3],"%d",&nbands_empty);
      Cfilled_filename  = argv[4];
      Cempty_filename = argv[5];
      Ccombined_filename = argv[6];
    }
  else
    {
      sprintf(line,"\nUsage:  %s latfile elecfile nbands_empty Cfilled Cempty Ccombined\n\n",argv[0]);
      die(line);
    }
  printf("latfile = '%s'\n",latfilename);
  printf("elecfile = '%s'\n",elecfilename);
  printf("nbands_empty = %d\n",nbands_empty);
  printf("Cfilled_file = '%s'\n",Cfilled_filename);
  printf("Cempty_file = '%s'\n",Cempty_filename);
  printf("Ccombined_file = '%s'\n",Ccombined_filename);

  /* Read the electronic state information: k-points, fillings, weights... */
  setup_elecinfo(&elecinfo,elecfilename,&basis,cntrl,REPORT_LEVEL,stdout);

  /* Read the lattice vectors and set up the bases */
  setup_basis(basis,latfilename,elecinfo,0,0,0,REPORT_LEVEL,stdout);

  /* Read in orthonormal wave-functions */
  if ( (Cfilledfile=fopen(Cfilled_filename,"r")) == (FILE *)0)
    {
      sprintf(line,"\nCan't open '%s' for reading.\n\n",Cfilled_filename);
      die(line);
    }
  if ( (Cemptyfile=fopen(Cempty_filename,"r")) == (FILE *)0)
    {
      sprintf(line,"\nCan't open '%s' for reading.\n\n",Cempty_filename);
      die(line);
    }
  if ( (Ccombinedfile=fopen(Ccombined_filename,"w")) == (FILE *)0)
    {
      sprintf(line,"\nCan't open '%s' for writing.\n\n",Ccombined_filename);
      die(line);
    }

  /* Do the conversion */
  int k,b;
  int max_nbasis = 0;
  for (k=0; k < elecinfo.nkpts; k++)
    if (max_nbasis < basis[k].nbasis)
      max_nbasis = basis[k].nbasis;
  vector band(max_nbasis);

  /* go over the k-points and bands and combine the data */
  for (k=0; k < elecinfo.nkpts; k++)
    {
      /* Read and write out the filled bands at this k-point */
      for (b=0; b < elecinfo.nbands; b++)
	{
	  printf("Working on k=%d/%d  filled band =%d/%d\n",
		 k,elecinfo.nkpts-1,b,elecinfo.nbands-1);
	/* read the band from Cfilled */
	fread(band.c,sizeof(scalar),basis[k].nbasis,Cfilledfile);
	/* write the tband */
	fwrite(band.c,sizeof(scalar),basis[k].nbasis,Ccombinedfile);
      }
      /* Read and write out the empty bands at this k-point */
      for (b=0; b < nbands_empty; b++)
	{
	  printf("Working on k=%d/%d   empty band =%d/%d\n",
		 k,elecinfo.nkpts-1,b,nbands_empty-1);
	/* read the band from Cfilled */
	fread(band.c,sizeof(scalar),basis[k].nbasis,Cemptyfile);
	/* write the tband */
	fwrite(band.c,sizeof(scalar),basis[k].nbasis,Ccombinedfile);
      }
    }

  printf("\nDone!!\n\n");

  fclose(Cfilledfile);
  fclose(Cemptyfile);
  fclose(Ccombinedfile);

  /* Free up all the used memory */
  free_basis(basis,elecinfo.nkpts);
  free_elecinfo(&elecinfo);
}
