/*
 * Routines that do various matrix multiplications.  These routines
 * are the computational Kernels for all the matrix multiplies in the code,
 * so optimizing them is the way to improve matrix multiplication
 * performance.
 */

/* $Id: matrix_mult.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_MATRIX_MULT_H
#define DFT_MATRIX_MULT_H

void small_block_matrix_mult(int n1, int n2, int nc,
			     int s1, int s2, int sc,
			     scalar *b1,scalar *b2,scalar *result);

void Y1dagY2_block_matrix_mult(const column_bundle &Y1,
			       const column_bundle &Y2,
			       matrix &M,
			       int n1, int n2, int N,
			       int offsetMrow,int offsetMcol,
			       int transpose,int offsetY2rowtranspose);

void Y_M_block_matrix_mult(const column_bundle &Y,
			   const matrix &M,
			   column_bundle &YM,
			   int N, int nrM, int ncM,
			   int offsetMrow, int offsetMcol,
			   int transpose,
			   int accum);

void matrix_matrix_block_matrix_mult(const matrix &m1,
				     const matrix &m2,
				     matrix &mprod);

#endif // DFT_MATRIX_MULT_H
