/*--------------------------  matrix  -----------------------------------*
 *                                                                       *
 * class: matrix whose elements are scalars (matrix.c)                   *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: matrix.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_MATRIX_H
#define DFT_MATRIX_H

class matrix
{
  /* data */
public:
  int nr,nc;    /* Number of rows and columns */
  scalar *c;    /* Holds the data */
  int hermetian;

  /* Constructors and destructor */
  matrix();
  matrix(int nrows,int ncols);
  matrix(const matrix &m1); /* copy constructor */
  ~matrix();
  
  /* Operators */
  void operator=(const matrix &m1);    /* Nonstandard: returns void */
  inline scalar &operator()(int i,int j) const
    { return c[nc*i+j]; }
  friend matrix operator+(const matrix &m1,const matrix &m2);
  friend matrix operator-(const matrix &m1,const matrix &m2);
  friend matrix operator*(const matrix &m1,const matrix &m2);
  friend matrix operator*(scalar s,const matrix &m);
  friend matrix operator*(const matrix &m, scalar s);
  friend matrix operator*(const diag_matrix &d, const matrix &m);
  friend matrix operator*(const matrix &m,const diag_matrix &d);
  void operator*=(scalar s);
  void operator+=(const matrix &m);
  
  /* member function: */
  /* Does the memory allocations of the constructor */
  void init(int nrows,int ncols);
  /* Free up memory */
  void freemem(void);
  /* Binary read/write matrix to/from fname */
  // to fully comply with MPI standard, read and  write also need to be
  // parallelized.
  void write(char *fname);
  void write(FILE *fp);
  void read(char *fname);
  void read(FILE *fp);
  /* zero out all the entries */
  void zero_out(void);
};

/* Allocate/free an array of matrices */
matrix *alloc_matrix_array(int nmats,int nrows,int ncols);
void free_matrix_array(int nmats,matrix *M);

/* Read/write an array of matrices from/to a file */
void read_matrix_array(char *fname,int nmatrices,matrix *M);
void write_matrix_array(char *fname,int nmatrices,matrix *M);

/* Trace and diagonal of matrix */
scalar trace(const matrix &m);
vector diag(const matrix &m);

/* Diagonalization routines, etc. */
void diagonalize_herm(real *eigs,matrix &evecs,matrix &a,int n);
matrix herm_adjoint(matrix &a);
matrix Uminusonehalf(matrix &U,matrix &W,real *u);
matrix Q(const matrix &G,matrix &W,real *mu);
matrix R(const matrix &A,matrix &Z,real *beta);
void scale_accumulate(int nmat,scalar s,matrix *min,matrix *mout);
real abs2(const matrix &m);
real abs2(int nmat,matrix *m);
scalar dot(matrix &A,matrix &B);
scalar dot(int nmat,matrix *A,matrix *B);

#endif // DFT_MATRIX_H
