****************************************************************************
*
* DFT++:  density functional package developed by
*         the research group of Prof. Tomas Arias, MIT.
*
* Principal author: Sohrab Ismail-Beigi
*
* Modifications for MPI version: Kenneth P Esler,
*                                Sohrab Ismail-Beigi, and
*                                Tairan Wang.
*
* Modifications for LSD version: Jason A Cline
*
* Modifications for lattice/Pulay forces: Gabor Csanyi and
*                                         Sohrab Ismail-Beigi
*
* Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
*
****************************************************************************

C
C $Id: essldiagF77.f,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $
c
c Diagonalize a real symmetric NxN matrix A
c and get eigenvalues and eigenvectors
c
      subroutine diagrs77_(eigs,evecs,A,AP,N)
      implicit none
      integer N
      real*8 eigs(N),evecs(N,N),A(N,N),AP(N*(N+1)/2)
c
c Workspace and parameters needed by DSYEV
c
      integer IOPT, LDZ, LWORK
      parameter (LWORK=5000)
      real*8 WORK(LWORK)
c
c Local variables
c
      integer i,j
c
c Setup some parameters
c
C IOPT = 
C     0 eigenvalue only, lower triangle 
C     1 eigenvector also, lower triangle
C     20 eigenvalue only, upper triangle
C     21 eigenvector also, upper triangle
      IOPT = 21
      LDZ = N
c
c Check for workspace size LWORK
c
      if (2*N.gt.LWORK) then
         write(6,*) 'Not enough work space allocated in diagrealsym',
     $        ' for matrix diagonalization.  Set LWORK >',
     $        2*N,'and recompile.'
         stop
      endif    
c
c Assume A is real and symmetric,
c Copy upper triangle of A into packed array evecs
c
      do i=1,N
         do j=i,N
            AP(i+(j-1)*j/2) = A(i,j)
         enddo
      enddo
c
c Do the call!
c
      call DSPEV(IOPT,AP,eigs,evecs,LDZ,N,WORK,LWORK)
c
c Done
c
      return
      end

c
c Diagonalize a complex Hermetian NxN matrix A
c and get eigenvalues and eigenvectors
c
      subroutine diagch77_(eigs,evecs,A,AP,N)
      implicit none
      integer N
      real*8 eigs(N)
      complex*16 evecs(N,N),A(N,N),AP(N*(N+1)/2)
c
c Workspace and parameters needed by DSYEV
c
      integer IOPT, LDZ, LWORK
      parameter (LWORK=5000)
      complex*16 RWORK(LWORK)
      complex*16 WORK(LWORK)
c
c Local variables
c
      integer i,j
c
c Setup some parameters
c
C IOPT = 
C     0 eigenvalue only, lower triangle 
C     1 eigenvector also, lower triangle
C     20 eigenvalue only, upper triangle
C     21 eigenvector also, upper triangle
      IOPT = 21
      LDZ = N
c
c Copy A into packed array AP.
c
      do i=1,N
         do j=i,N
            AP(i+(j-1)*j/2) = A(i,j)
         enddo
      enddo
c
c Check for workspace size LWORK
c
      if (4*N.gt.LWORK) then
         write(6,*) 'Not enough work space allocated in diagrealsym',
     $        ' for matrix diagonalization.  Set LWORK >',
     $        4*N,'and recompile.'
         stop
      endif    
c
c Do the call!
c
      call ZHPEV(IOPT,AP,eigs,evecs,LDZ,N,WORK,LWORK)
c
c Done
c
      return
      end
         
 
 
 
 
 
 
 
