/****************************************************************************
 *
 * DFT++:  density functional package developed by
 *         the research group of Prof. Tomas Arias, MIT.
 *
 * Principal author: Sohrab Ismail-Beigi
 *
 * Modifications for MPI version: Kenneth P Esler,
 *                                Sohrab Ismail-Beigi, and
 *                                Tairan Wang.
 *
 * Modifications for LSD version: Jason A Cline
 *
 * Modifications for lattice/Pulay forces: Gabor Csanyi and
 *                                         Sohrab Ismail-Beigi
 *
 * Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
 *
 ****************************************************************************/

/*
 * Sohrab Ismail-Beigi,   Aug. 29 1997
 *
 * Dump the electronic variables to disk files.
 *
 */

/* $Id: dump.c,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#include <math.h>
#include <stdio.h>
#include <time.h>

/* My header file */
#include "header.h"

/*
 * Dumps the specified electronic variables to disk and time stamps them.
 */
void
dump_and_stamp_variables(Elecinfo &elecinfo,
			 Elecvars &elecvars)
{
  time_t timenow;
  struct tm *mytm;
  char stamp[DFT_MSG_LEN],fname[DFT_FILENAME_LEN];

  /* Set up date/time stamp */
  timenow = time(0);
  mytm = localtime(&timenow);
  sprintf(stamp,"%d.%d.%d:%d:%d",
	  mytm->tm_mon+1,mytm->tm_mday,
	  mytm->tm_hour,mytm->tm_min,mytm->tm_sec);

  /* Dump the data! */

  if (elecvars.C)
    {
      sprintf(fname,"C.%s",stamp);
      dft_log("Dumping '%s'...",fname);
      dft_log_flush();
      write_column_bundle_array(fname,elecinfo.nkpts,elecvars.C);
      dft_log("done.\n");
      dft_log_flush();
    }

  if (elecvars.n.c)
    {  
      sprintf(fname,"n.%s",stamp);
      dft_log("Dumping '%s'...",fname);
      dft_log_flush();
      elecvars.n.write(fname);
      dft_log("done.\n");
      dft_log_flush();
    }

  if (elecvars.d.c)
    {
      sprintf(fname,"d.%s",stamp);
      dft_log("Dumping '%s'...",fname);
      dft_log_flush();
      elecvars.d.write(fname);
      dft_log("done.\n");
      dft_log_flush();
    }

  if (elecvars.Vlocps.c)
    {
      sprintf(fname,"Vlocps.%s",stamp);
      dft_log("Dumping '%s'...",fname);
      dft_log_flush();
      elecvars.Vlocps.write(fname);
      dft_log("done.\n");
      dft_log_flush();
    }

  if (elecvars.Vscloc.c)
    {
      sprintf(fname,"Vscloc.%s",stamp);
      dft_log("Dumping '%s'...",fname);
      dft_log_flush();
      elecvars.Vscloc.write(fname);
      dft_log("done.\n");
      dft_log_flush();
    }

  if (elecvars.Hsub_evecs)
    {
      sprintf(fname,"Hsub_evecs.%s",stamp);
      dft_log("Dumping '%s'...",fname);
      dft_log_flush();
      write_matrix_array(fname,elecinfo.nkpts,elecvars.Hsub_evecs);
      dft_log("done.\n");
      dft_log_flush();
    }

  if (elecinfo.calc_fillings)
    {
      sprintf(fname,"F.%s",stamp);
      Output fillingsfile(fname);
      elecinfo.print_fillings(&fillingsfile);
    }
}
