/*------------------------  diag_matrix  --------------------------------*
 *                                                                       *
 * diag_matrix class:                                                    *
 *                 a diagonal matrix of scalar elements (diag_matrix.c)  *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: diag_matrix.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_DIAG_MATRIX_H
#define DFT_DIAG_MATRIX_H

class diag_matrix
{
  /* data */
public:
  int n;
  scalar *c;
  Basis *basis;

  /* Constructors and destructor */
  diag_matrix();
  diag_matrix(int len);
  diag_matrix(int len,Basis *b);
  diag_matrix(const diag_matrix &d1);
  ~diag_matrix();
  
  /* Operators */
  void operator=(const diag_matrix &d1); /* Non-std: = returns void */

  /* Member functions: */
  /* Does what the constructor does */
  void init(int len,Basis *b);
  /* free up memory */
  void freemem(void) { free(c); }          /* free the memory */
  /* print vector to stdout */
  void print() const;
  /* Zero out the elements of the diag_matrix */
  void zero_out(void);
};

#endif // DFT_DIAG_MATRIX_H
