/* 
 * Gabor Csanyi, June 1999
 * 
 * header file for
 *
 * generalized I/O functions to handle serial and MPI in a unified way
 * 
 * dft_fopen()
 * dft_fclose()
 * dft_fread() BUG: assumes data is type double
 * dft_fwrite()
 *
 */

/* $Id: dft_io.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_DFT_IO_H
#define DFT_DFT_IO_H

/* 
 * dft_fopen() opens a file and returns the file pointer. arguments
 * are as in standard fopen(). If called in a serial context, it
 * simply executes a system fopen(). If called in an MPI context, it
 * executes a fopen() on the I/O node, and returns a NULL on all the
 * other nodes.
 */
FILE * dft_fopen(char *filename, char *access_string);

/* 
 * dft_fclose() closes the stream pointed to by its argument. if the
 * argument is NULL, it does nothing.
 */
void dft_fclose(FILE *stream);

/*
 * dft_fwrite() called in a scalar context just does an fwrite(). in an
 * MPI context, it does an fwrite if executed in the I/O node, and nothing
 * on any other node. returns the number of bytes written.
 */
size_t dft_fwrite(const void *data, size_t size, size_t nmemb, FILE *stream);
size_t dft_fread(void *data, size_t size, size_t nmemb, FILE *stream);

/* Does a file flush */
int dft_fflush(FILE *stream);

/* Does vfprintf */
int dft_vfprintf(FILE *stream, char *format, va_list ap);

#endif // DFT_DFT_IO_H

