/*-----------------------  Speciesinfo  ---------------------------------*
 *                                                                       *
 * Contains information for one ion species                              *
 *                                                                       *
 * This structure, together with Ioninfo (and IonDyninfo if necessary),  *
 * defines the ions and their pseudopotentials                           *
 * (Member functions in setup_ions.c)                                    *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Speciesinfo.h,v 1.3 2000/01/25 04:53:44 tairan Exp $ */

#ifndef DFT_SPECIESINFO_H
#define DFT_SPECIESINFO_H

class Speciesinfo
{
public:
  /* basic information */
  char name[DFT_MSG_LEN];     /* Identifier */
  int sp_id;                  /* numerical ID */
  char potfile[DFT_MSG_LEN], pulayfile[DFT_MSG_LEN];

  real Z;                     /* Nuclear charge of the species*/
  int natoms;                 /* Number of atoms and their positions */
  vector3 *atpos;

  real dEperNatoms_dNGperVol; /* Derivative of total energy per number of
				 atoms versus the number of planewaves
				 per volume */
  real mass;                  /* ionic mass for dynamics */
  int *move;                  /* mask for whether the ion is allowed to move */
  vector3 *forces;            /* forces on the atoms in lattice coords */

  int *maps[48];               /* for force symmetry calculation */

  /* Tairan Wang, Oct 8, 1999: added for ion relaxations */
  vector3 *ion_speed;
  double ion_damp;
  double ion_fac;


  /* local pseudopotential */
  int ngrid_loc;              /* number of points on the q-grid describing
				 the local pseudopotential */
  real dq_loc;                /* grid spacing */
  real *V_loc;                /* V[q]: the local pseudopotential in q space */
  /* nonlocal pseudopotentials: multiple-projector extension of
     Kleinman-Bylander */  
  int nlm;           /* number of (l,m) states */
  int *l,*m;         /* l and m values for each of the nlm states */
  int *ngamma;       /* Number of states for given (l,m) */
  matrix *M;         /* ngamma[lm]^2 sized matrix describing the potential */
  int **ngrid_nl;    /* ngrid[lm][gamma] is the q-grid size for flq which
			describes the non-local potential */
  real **dq_nl;      /* grid spacing: dq[lm][gamma] */
  real ***flq;       /* flq[lm][gamma][] describes the non-local potential */
  

  // For elements with non-linear core correction, the followings are used.
  int nl_core_flag;  // indicate whether nlcore is used.
  int n_core_grid;
  real clog_core_grid;
  real *core_r, *n_core;  // tabulates  n_core(r)

  /*
   *  Member functions:
   *
   */
  void print() const;  // print Z, mass, natoms, and atomic positions.
  void print_force(const matrix3 &invR) const;  // print force.
  void setup_pulay(const char *pulayfilename, real einfoEcut);
};

#endif // DFT_SPECIESINFO_H
