/*------------------------  Parameters  ---------------------------------*
 *                                                                       *
 * This class contains the parameters for main program that's read from  *
 * the input file in  setup()                                            *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Parameters.h,v 1.3 2000/02/03 06:20:32 tairan Exp $ */

#ifndef DFT_PARAMETERS_H
#define DFT_PARAMETERS_H

class Parameters
{
public:
  int electronic_minimization_flag,
    calculate_forces_flag,
    ionic_dynamics_flag,
    ionic_relaxation_flag;
  

  int read_Y_flag;
  char init_Y_filename[DFT_FILENAME_LEN],
       old_Y_filename[DFT_FILENAME_LEN];

  // Tairan : 9/30/99. Debugging testing flag.
  int testing_flag;

  // Tairan : 9/28/99. Calculate partial charge density.
  int number_of_partial_n_lines;
  int *partial_n_kpt, *partial_n_band;

  // Tairan : 11/6/99. 
  int template_printing;

  /* constructor */
  Parameters() {
    electronic_minimization_flag = DFT_FALSE;
    calculate_forces_flag        = DFT_FALSE;
    ionic_dynamics_flag          = DFT_FALSE;
    ionic_relaxation_flag        = DFT_FALSE;

    read_Y_flag = DFT_FALSE;
    strcpy(init_Y_filename,"C.temp1");
    strcpy(old_Y_filename,"C.temp2");

    testing_flag = DFT_FALSE;
    number_of_partial_n_lines = 0;

    template_printing = DFT_TRUE;
  }
};

#endif // DFT_PARAMETERS_H

