/*--------------------------  PHLO.c  -----------------------------------*
 *                                                                       *
 * Implement matrix operators: P, Hsp, L, O, Obar, etc...                *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: PHLO.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_PHLO_H
#define DFT_PHLO_H

/* Multiply by Laplacian */
vector L(const vector &v);
column_bundle L(const column_bundle &Y);
void apply_L(const column_bundle &Y,column_bundle &LY);
/* Multiply vector by inverse Laplacian (except for G=0) */
vector invL(const vector &v);
/* Multiply by overlap matrix */
vector O(const vector &v);
vector Obar(const vector &v);
column_bundle O(const column_bundle &Y);
void apply_O(const column_bundle &Y,column_bundle &OY);
/* Good for plane-waves where O is identity...it does nothing! */
void apply_O_inplace(column_bundle &Y);
/* Return (I-P)Y where P=O*C*C^, the projection matrix */
column_bundle Pbar(const column_bundle &C,const column_bundle &Y);
/* Same as Pbar() but uses less memory:  does PbarY = Pbar(Y). */
void apply_Pbar(const column_bundle &C,
		const column_bundle &Y,
		column_bundle &PbarY);
/* Multiply column_bundle by single particle Hamiltonian */
column_bundle Hsp(const column_bundle &Y,Ioninfo *ioninfo);
void apply_Hsp(const column_bundle &Y,
	       Ioninfo *ioninfo,
	       column_bundle &HspY);
/* Multiply column_bundle by inverse kinetic preconditioner inv((k+G)^2/2)*/
void precond_inv_kinetic(column_bundle &Y,real KErollover);

#endif // DFT_PHLO_H
