/*------------------------  Energies  -----------------------------------*
 *                                                                       *
 * Structure containing various terms in the energy                      *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Energies.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_ENERGIES_H
#define DFT_ENERGIES_H

class Energies
{
public:
  real KE;       /* Kinetic energy */
  real Eloc;     /* Local pseudopotential energy */
  real Ecore;    /* Pseudopotential core energy */
  real Enl;      /* Non-local pseudopotential energy */
  real EH;       /* Hartree energy */
  real Exc;      /* Exchange-correlation energy */
  real Eewald;   /* Ewald energy */
  real Epulay;   /* Pulay correction energy */
  real Etot;     /* Total:  sum of all above */
  real F;        /* The Helmholtz free energy F = Etot - T*S; only
		  * used when we do finite temperature and calculate 
		  * fillings */

  // initialize all to 0.
  Energies() { KE=Eloc=Ecore=Enl=EH=Exc=Eewald=Epulay=Etot=F= 0.0; }
};

#endif // DFT_ENERGIES_H
