/*------------------------  Elecvars  -----------------------------------*
 *                                                                       *
 * Structure containing the electronic variables                         *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Elecvars.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_ELECVARS_H
#define DFT_ELECVARS_H

class Elecvars
{
public:
  column_bundle *Y;         /* unconstrained electronic wavefunctions */
  matrix *U;                /* U[k] = Y[k]^O(Y[k]) */
  matrix *W; real **mu;     /* U[k] = W[k]*mu[k]*W[k]^ */
  matrix *Umhalf;           /* Uhmalf[k] = U[k]^(-1/2) */
  column_bundle *C;         /* C[k] = Y[k]*U[k]: orthonormal wavefuncs */
  vector n;                 /* electron density on real space grid */
  vector ncore;             /* core-electron-density, for non-linear core correction */
  vector d;                 /* electrostatic potential */
  vector Vlocps;            /* Local pseudopotential */
  vector Vscloc;            /* Local part of self-consistent potential */
  matrix *Hsub;             /* Subspace Hamiltonian:  Hsub[k]=C[k]^H*C[k] */
  matrix *Hsub_evecs;       /* eigen-vectors of Hsub[k] (in cols) */
  real **Hsub_eigs;         /*       values of Hsub[k] */
  /* The below are for the subspace rotation variables */
  matrix *B,*V;             /* V = exp(iB): C = Y*U^(-1/2)*Vdag; */
  matrix *Z; real **beta;   /* B = Z*beta*Zdag (eigen decomposition of B) */
  /*
   * The following switch is to select exchange-correlation functionals. 
   * It basically copy that of Elecinfo. The program structure forces this 
   * redunduncy right now.  Need to be fixed.
   */
  int ex_opt;
};

#endif // DFT_ELECVARS_H
