/*-------------------------  Control  -----------------------------------*
 *                                                                       *
 * This class contains control criteria and data members for electronic  *
 * minimizations and others.  (member functions in  system.c)            *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Control.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_CONTROL_H
#define DFT_CONTROL_H

class Control
{
  int converged;      // flag to indicate convergence. 1: converged.

  real Etot;
  real Etot_old;
  real Etot_old_old;

public:
  real E_tolerance;      // 0.0 by default.
  real force_tolerance;  // 0.0 by default.
  int update_stepsize;   /* In do_linmin of electronic minimization;
			    If this flag is set, stepsize = gamma.
			    This flag is set by default;
			    overwrite it with 
			       cntrl-update-stepsize [no|0|No]
			    in input file, or in case of old input format
			           [1,0]  # update_stepsize  <comments>
			    in elecs.in */
  real stepsize_min;  /* minimum of stepsize, default is 1e-5.
			 This is for prevent too small a stepsize resulting 
			 in numerical instability.
			 overwrite it with
			       cntrl-stepsize-min <value>
			 in input file, or in case of old input format
			           <value> # stepsize_min  <comments>
			 in elecs.in  */
  real nel_fermi_tol;   /* tolerance of number of electrons in 
			   calc_fermi_fillings, default is  1e-8.
			   overwirte it with
			       cntrl-nel-fermi-tol <value>
			   in input file, or in case of old input format
			           <value> # nel_fermi_tol <comments>
			   in elecs.in */
  int dump_n;  /* if set, dump charge density at each step of 
		  a ion dynamic run.  Default is set.
		  Override with
		     cntrl-dump-n [f|0|n]
		  in input file.
	       */

  int algorithm;   /* take one of of  DFT_CG, DFT_CG_nocos, ... DFT_PSD,
		      default: DFT_PCG_nocos
		   */

  int max_ionic_steps;  /* maximum number of electronic steps during electronic minimization
			   default: 20
			 */

  int max_elecs_steps;  /* maximum number of electronic steps during electronic minimization
			   default: 20
			 */

  real elec_stepsize;  /* the initial electronic stepsize. default: -1.0 */


  /* constructor */
  Control();

  int if_e_converged(real E);
  void reset_converge();
  void print(Output *out, int iter);
};

#endif // DFT_CONTROL_H
