/*
 * Tairan Wang,                  Feburary 2, 1999
 *
 * 
 * Utility subroutines for DFT C++ code.
 *
 */

/* $Id: utils.c,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include "header.h"
#include "parallel.h"

/* 
 * Skip the comments inbetween fields.
 * line  contains the line just after the comment afterwards.
 */
void
skip_comment(dft_text_FILE* filep, char* line) 
{
  do
    {
      dft_text_fgets(line,DFT_LINE_LEN,filep);
    }
  while(line[0] == '#');
}

/*
 * character '#' signals the start of a comment,
 *
 * remove comment from  line  by writing a '\0'
 * at the position of the first if any '#'.
 *
 */
void
remove_comment(char* line)
{
  int i, len = strlen(line);

  for (i = 0; i < len; i++)
    {
      if (line[i] == '#')
	{
	  line[i] = '\0';
	  break;
	}
    }
  return;
}

/*
 * raise a real number to an integer power
 */
real 
pow(real a, int b)
{
  real f = 1.0;
  for (int i=0; i<b; i++) {
    f *= a;
  }
  return f;
}

/*
 * match_yes
 * 
 * returns DFT_TRUE is key matches 
 * Y*, y*, T*, t*, 1
 */
int 
match_yes(const char *key) 
{
  if ( (key[0] == 'y') ||
       (key[0] == 't') ||
       (key[0] == '1') ||
       (key[0] == 'Y') ||
       (key[0] == 'T') )
    return DFT_TRUE;
  else
    return DFT_FALSE;
}

/*
 * match_no
 * 
 * returns DFT_TRUE is key matches 
 * N*, n*, F*, f*, 0
 */
int 
match_no(const char *key) 
{
  if ( (key[0] == 'n') ||
       (key[0] == 'f') ||
       (key[0] == '0') ||
       (key[0] == 'N') ||
       (key[0] == 'F') )
    return DFT_TRUE;
  else
    return DFT_FALSE;
}

/*
 * simps  integration for  f  with step length  h  for  n points
 * n  should be odd.
 */
real simps(int n, real* f, real h)
{
  real result;
  int nm12 = (n-1)/2, i;

  if ( (nm12*2) != (n-1) )
    die("Function simps: n must be odd, but is not.");

  result = f[0];
  for (i = 1; i < (n-1); i += 2)
    result += 4 * f[i] + 2 * f[i+1];
  result -= f[n-1];

  result *= (h/3);
  
  return(result);
}
