/****************************************************************************
 *
 * DFT++:  density functional package developed by
 *         the research group of Prof. Tomas Arias, MIT.
 *
 * Principal author: Sohrab Ismail-Beigi
 *
 * Modifications for MPI version: Kenneth P Esler,
 *                                Sohrab Ismail-Beigi, and
 *                                Tairan Wang.
 *
 * Modifications for LSD version: Jason A Cline
 *
 * Modifications for lattice/Pulay forces: Gabor Csanyi and
 *                                         Sohrab Ismail-Beigi
 *
 * Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
 *
 ****************************************************************************/

/*
 *     Sohrab Ismail-Beigi           Mar. 30, 1997
 *
 * Solve the Poisson equation.
 *
 */

/* $Id: poisson.c,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#include <stdio.h>
#include <math.h>
#include "header.h"

/*
 * Solve poisson equation...trivial for a planewave basis!
 *
 *     d = -4*pi*invL(Obar(J(n))).
 */
void
solve_poisson(Elecvars *evars)
{
#ifdef DFT_PROFILING
  timerOn(17);   // Turn on solve_poisson timer
#endif // DFT_PROFILING

  const real pi = M_PI;
  vector &n = evars->n;
  vector &d = evars->d;

  d = (scalar)(-4.0*pi)*invL(Obar(J(n)));

#ifdef DFT_PROFILING
  timerOff(17);   // Turn off solve_poisson timer
#endif // DFT_PROFILING
}
