/****************************************************************************
 *
 * DFT++:  density functional package developed by
 *         the research group of Prof. Tomas Arias, MIT.
 *
 * Principal author: Sohrab Ismail-Beigi
 *
 * Modifications for MPI version: Kenneth P Esler,
 *                                Sohrab Ismail-Beigi, and
 *                                Tairan Wang.
 *
 * Modifications for LSD version: Jason A Cline
 *
 * Modifications for lattice/Pulay forces: Gabor Csanyi and
 *                                         Sohrab Ismail-Beigi
 *
 * Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
 *
 ****************************************************************************/

/*
 *     Tairan Wang                     Sep 28, 1999
 *
 * Temporary place to hold new subroutines.
 *
 */

/* $Id: other.c,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#include <stdio.h>
#include <math.h>
#include "header.h"

/*
 * This subroutine is used to calculate partial charge 
 * density from the wavefunction.
 *
 * The partial charge parameters are stored in 
 * file partial_n_filename.
 */
void calc_partial_n(Parameters &params, Elecinfo *einfo, Elecvars *evars)
{
  /* Set up date/time stamp */
  time_t timenow;
  struct tm *mytm;
  char stamp[DFT_MSG_LEN],fname[DFT_FILENAME_LEN];

  timenow = time(0);
  mytm = localtime(&timenow);
  sprintf(stamp,"%d.%d.%d:%d:%d",
	  mytm->tm_mon+1,mytm->tm_mday,
	  mytm->tm_hour,mytm->tm_min,mytm->tm_sec);

  calc_U(einfo,evars);
  calc_V(einfo,evars);
  calc_C(einfo,evars);

  column_bundle *C = evars->C;


  int i, k, b;
  diag_matrix F;
  vector n = evars->n; // make a copy of the charge density.

  for (i = 0; i < params.number_of_partial_n_lines; i++) {
    k = params.partial_n_kpt[i];
    b = params.partial_n_band[i];

    F.init(einfo->nbands,einfo->F[k].basis);
    F.c[b] = 2.0;

    n = diagouterI(F,C[k]);
    // no symmetrize of charge density.

    // dump charge density out.
    /* Dump the data! */
    sprintf(fname,"orbital_k%d_b%d.%s",k,b,stamp);
    dft_log("Dumping '%s'...\n",fname);
    dft_log_flush();
    n.write(fname);

    F.freemem();
  }

  dft_log("done.\n");
  dft_log_flush();

}
