****************************************************************************
*
* DFT++:  density functional package developed by
*         the research group of Prof. Tomas Arias, MIT.
*
* Principal author: Sohrab Ismail-Beigi
*
* Modifications for MPI version: Kenneth P Esler,
*                                Sohrab Ismail-Beigi, and
*                                Tairan Wang.
*
* Modifications for LSD version: Jason A Cline
*
* Modifications for lattice/Pulay forces: Gabor Csanyi and
*                                         Sohrab Ismail-Beigi
*
* Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
*
****************************************************************************

C
C $Id: lapackdiagF77.f,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $
c
c Diagonalize a real symmetric NxN matrix A
c and get eigenvalues and eigenvectors
c
      subroutine diagrs77(eigs,evecs,A,N)
      implicit none
      integer N
      real*8 eigs(N),evecs(N,N),A(N,N)
c
c Workspace and parameters needed by DSYEV
c
      character JOBZ, UPLO
      integer INFO, LDA, LWORK
      parameter (LWORK=5000)
c Tairan 6/13/98, no need for RWORK
c      real*8 RWORK(LWORK)
      real*8 WORK(LWORK)
c
c Local variables
c
      integer i,j
c
c Setup some parameters
c
      JOBZ = 'V'
      UPLO = 'U'
      LDA = N
c
c Copy A into evecs
c
      do i=1,N
         do j=1,N
            evecs(i,j) = A(i,j)
         enddo
      enddo
c
c Check for workspace size LWORK
c
      if (3*N-1.gt.LWORK) then
         write(6,*) 'Not enough work space allocated in diagrealsym',
     $        ' for matrix diagonalization.  Set LWORK >',
     $        3*N-1,'and recompile.'
         stop
      endif    
c
c Do the call!
c
c Tairan 6/13/98, calling convention does not have RWORK
c      call DSYEV(JOBZ,UPLO,N,evecs,LDA,eigs,WORK,LWORK,RWORK,INFO)
      call DSYEV(JOBZ,UPLO,N,evecs,LDA,eigs,WORK,LWORK,INFO)
c
c Check for errors
c
      if (INFO.ne.0) then
         write(6,*) 'Error in calling DSYEV, INFO = ',INFO
         stop
      endif
c
c Done
c
      return
      end

c
c Diagonalize a complex Hermetian NxN matrix A
c and get eigenvalues and eigenvectors
c
      subroutine diagch77(eigs,evecs,A,N)
      implicit none
      integer N
      real*8 eigs(N)
      complex*16 evecs(N,N),A(N,N)
c
c Workspace and parameters needed by DSYEV
c
      character JOBZ, UPLO
      integer INFO, LDA, LWORK
      parameter (LWORK=5000)
      complex*16 RWORK(LWORK)
      complex*16 WORK(LWORK)
c
c Local variables
c
      integer i,j
c
c Setup some parameters
c
      JOBZ = 'V'
      UPLO = 'U'
      LDA = N
c
c Copy A into evecs
c
      do i=1,N
         do j=1,N
            evecs(i,j) = A(i,j)
         enddo
      enddo
c
c Check for workspace size LWORK
c
      if (2*N-1.gt.LWORK) then
         write(6,*) 'Not enough work space allocated in diagrealsym',
     $        ' for matrix diagonalization.  Set LWORK >',
     $        2*N-1,'and recompile.'
         stop
      endif    
c
c Do the call!
c
      call ZHEEV(JOBZ,UPLO,N,evecs,LDA,eigs,WORK,LWORK,RWORK,INFO)
c
c Check for errors
c
      if (INFO.ne.0) then
         write(6,*) 'Error in calling ZHEEV, INFO = ',INFO
         stop
      endif
c
c Done
c
      return
      end
         
 
 
 
 
 
 
 
