/****************************************************************************
 *
 * DFT++:  density functional package developed by
 *         the research group of Prof. Tomas Arias, MIT.
 *
 * Principal author: Sohrab Ismail-Beigi
 *
 * Modifications for MPI version: Kenneth P Esler,
 *                                Sohrab Ismail-Beigi, and
 *                                Tairan Wang.
 *
 * Modifications for LSD version: Jason A Cline
 *
 * Modifications for lattice/Pulay forces: Gabor Csanyi and
 *                                         Sohrab Ismail-Beigi
 *
 * Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
 *
 ****************************************************************************/

/*
 * Sohrab Ismail-Beigi,     April 8 1997 
 *
 * This file contains C to FORTRAN 77 interface routines for diagonalization
 * via Lapack routines.  Clearly machine dependent, so have fun!
 *
 */

/* $Id: lapackdiagC.c,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#include <stdio.h>
#include <stdlib.h>

/* define real and complex numbers */
typedef double real;
struct complex_struct
{
  real x,y;
};
typedef struct complex_struct complex;


#if defined DFT_USE_LAPACK

/* The FORTRAN 77 Lapack routines to call:  they are in lapackdiagF77.f */
#if defined DFT_CRAYT3E
void DIAGCH77(real *eigs,complex *evecs,complex *A,int *n);
void DIAGRS77(real *eigs,real *evecs,real *A,int *n);
#else
void diagch77_(real *eigs,complex *evecs,complex *A,int *n);
void diagrs77_(real *eigs,real *evecs,real *A,int *n);
#endif

/* Just call the FORTRAN */
int
diagch77_C(real *eigs,complex *evecs,complex *A,int *n)
{
#if defined DFT_CRAYT3E
  DIAGCH77(eigs,evecs,A,n);
#else
  diagch77_(eigs,evecs,A,n);
#endif
  return 0;
}

int
diagrs77_C(real *eigs,real *evecs,real *A,int *n)
{
#if defined DFT_CRAYT3E
  DIAGRS77(eigs,evecs,A,n);
#else
  diagrs77_(eigs,evecs,A,n);
#endif
  return 0;
}

#elif defined DFT_USE_ESSL

/* The FORTRAN 77 Essl routines to call: they are in lapackdiagF77.essl.f */
void diagch77_(real *eigs,complex *evecs,complex *A,complex *AP,int *n);
void diagrs77_(real *eigs,real *evecs,real *A,real *AP,int *n);

/* also have to access the memory allocation rouinte in mem.c to allocate
   space for packed array. This could be a pain, allocating and deallocating
   every time one calls these routines 
void * mymalloc(int size, char* what, char* where);
*/

int
diagch77_C(real *eigs, complex *evecs, complex *A, int *n)
{
  complex *AP;

  /*
   * allocate temporary buffer for packed A: AP(n*(n+1)/2) 
   * It would be nice to use mymalloc in mem.C
   *
   * If we really want to do this, we could make this a C++ program 
   * and declare the fortran routines as external C.
   * And remove the external C declaration referred to the functions
   * in here from  matrix.C
   *                              -- Tairan 11/19/1997
   */
  if ((AP = (complex*) malloc( sizeof(complex)*(*n)*(*n+1)/2 )) == NULL)
    return 1;
  
  diagch77_(eigs,evecs,A,AP,n);

  free(AP);
}

int
diagrs77_C(real *eigs, real* evecs, real *A, int *n)
{
  real *AP;

  /* allocate temporary buffer for packed A: AP(n*(n+1)/2) */
  if ( (AP = (real*) malloc( sizeof(real)*(*n)*(*n+1)/2 )) == NULL)
    return 1;

  diagrs77_(eigs,evecs,A,AP,n);

  free(AP);
}

#else
#error got to use some scientific library, Lapack, Essl, ...
#endif
