/*--------------------------- dft_text_FILE.h ---------------------------*
 *                                                                       *
 *  is used in  Professor Arias's file IO suite. (dft_text_FILE.c)       *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: dft_text_FILE.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_TEXT_FILE_H
#define DFT_TEXT_FILE_H

//
// Define dft_text_FILE class:
// It is used to read in text files for setup, etc. that need
// to be distributed to all nodes/processes if we are running
// in a parralelized MPI mode.  In such a case, the main process/node
// reads the entire file as a big string and broadcasts it to everyone.
// Then the processes call routines like dft_text_fscanf or _fgets that
// just go through the string.
//
class dft_text_FILE
{
public:
  int my_id, io_id;
  long int file_length;
  char* file_string;
  char *current_pointer, *old_pointer;
  FILE* file_handle;
  dft_text_FILE();
  ~dft_text_FILE();
  void init();
  void expand_include();
};

/* And functions that use it */
dft_text_FILE *dft_text_fopen(const char *filename, const char *type);
int dft_text_fclose(dft_text_FILE* file);
char * dft_text_fgets(char * s, int n, dft_text_FILE * file);
char * dft_text_fgets(char * s, int n, char c, dft_text_FILE * file);
int dft_text_fscanf( dft_text_FILE *file, const char *fmtin, ...);
void dft_text_rewind(dft_text_FILE* file);

#endif // DFT_TEXT_FILE_H
