/*-------------------------  constants.h  --------------------------------*
 *                                                                        *
 * Some physical constants translation.                                   *
 * These are meant to make it easier for users to use units they are      *
 * familiar with to specify, say  atomic mass, electronic temperature.    *
 *                                                                        *
 * But be weary that mistakes here could lead to wrong results, weeks of  *
 * debugging, and frustration in general.                                 *
 *                                                                        *
 *------------------------------------------------------------------------*/

/* $Id: constants.h,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#ifndef DFT_CONSTANTS_H
#define DFT_CONSTANTS_H

//  1 hartree/(bohr/fsec)^2 = 0.937583 nucleon weight (1.66e-27 kg)
#define Std2AtomicMass  0.937583   

//  1 eV = 0.0367490 Hartree
#define eV2Hartree      0.0367490  

//  1 Kelvin  =  3.16666e-6  Hartree
#define K2Hartree       3.16666e-6


#endif // DFT_CONSTANTS_H
