/*---------------------------- System -----------------------------------*
 *                                                                       *
 *  System class: takes care of System paramters (i.e. the computer      *
 *                system) and parallelization information.               *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: System.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_SYSTEM_H
#define DFT_SYSTEM_H

#include "Output.h"

class System
{
  /**************************************************
   ** This data structure is the only one          **
   ** that needs to know about the system          **
   ** architecture.                                **
   **                                              **
   ** Static data needs to be                      **
   ** initialized at the very beginning of         **
   ** the program.                                 **
   **                                              **
   ** This class plays the role of the             **
   ** caretaker of parallelization setup (e.g. MPI)**
   ** Never should an object of this class         **
   ** be actually created.                         **
   **************************************************/
protected:
  static int N_Procs, My_procID;

public:
  static Output *global_log;  // Where all the logging info. goes...

public:
  // static member function, initializing system 
  // dependent static members
  static void GlobalInit(int* argc, char*** argv);
  static void GlobalFinalize();
  static int Get_procID() { return My_procID; }
  static int Get_N_Procs() { return N_Procs; }
  // MPI_IO indicates which processor(s) has full IO access.
  // For now, assume processor 0 is such a processor.
  static int Get_IOprocID() { return 0; }

  static double get_time();  // provide transparent access to system timer

  static void seed_with_time(int flag); // flag: DFT_SMALL_DATA or DFT_LARGE_DATA
  static void seed_with_time(void) {
    // default to seed_with_time(DFT_LARGE_DATA)
    System::seed_with_time(DFT_LARGE_DATA);
  }

  // A do-nothing constructor
  System();
};


// this is a good place to put the die function
void die(const char *last_words, ...);

#endif // DFT_SYSTEM_H
