/*----------------------------- Output ----------------------------------*
 *                                                                       *
 *  Output class:  takes care of output to a file (Output.c)             *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Output.h,v 1.3 1999/12/19 16:31:54 tairan Exp $ */

#ifndef DFT_OUTPUT_H
#define DFT_OUTPUT_H

class Output
{
public:
  int report_level; // do no print if report_level < DFT_SILENCE
  char filename[DFT_FILENAME_LEN];
  FILE *fp;

  Output();
  Output(int level);
  Output(char *fname);
  Output(char *fname,char *mode);
  Output(int level,char *fname);
  Output(int level,char *fname,char *mode);
  ~Output();

  int get_level() const { return report_level; }
  int flush();

  int printf(const char *fmtin, ...) const;
  int printf(int level, const char *fmtin, ...) const;
  int vprintf(int level, const char *format, va_list ap) const;

};

#endif // DFT_OUTPUT_H
