/*-----------------------  IonDyninfo  ----------------------------------*
 *                                                                       *
 *  Tairan Wang,          Mar 31. 1999                                   *
 *                                                                       *
 * Class IonDyninfo:                                                     *
 *    Extended class from Ioninfo to include dynamics information        *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: IonDyninfo.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_IONDYNINFO_H
#define DFT_IONDYNINFO_H

class IonDyninfo 
{
 public:
  Ioninfo ioninfo;  // static ion information

  // ionic-run control parameters:
  int ion_start_iter;
  char ion_dyn_action[DFT_MSG_LEN];

  // Rotator files for disk-cached wavefunctions for extrapolateion in ion dynamics.
  char *oldFileRead; 
  char *oldFileWrite;

  // for Verlet dynamics
  vector3 **atpos_old;
  vector3 **atpos_next;
  vector3 **atvel;

  matrix3 AAT;  // lattice vector dot products
  matrix3 invR; // inverse of lattice vector matrix
  matrix3 RRT;  // invR * (invR)'

  Basis *basis;
  real ionic_kT,  // in Hartree
    ionic_stepsize;  // in femto-second
  int velsc_flag ;  

 public:
  IonDyninfo();
  ~IonDyninfo();

  void print_force() const { // print out forces.
    ioninfo.print_force(invR);
  }
  void print_pos(Output *out, int flag) const;
  void print_pos(Output *out, int flag, int nstep) const;

  // local function prototypes:
  void ioninit();
  void ioncontinue( Elecinfo *elecinfo );
  void iondyn( int iter );
  void extrapolate_column_bundle_array(char *oldfname, int nbundles, 
				   column_bundle *C, column_bundle *Y);
  
  void check_pos();

  int dump_n_extrapolate_Y( Elecvars &elecvars, const Control &cntrl,
			   int nkpts, int iter);


  // Tairan 10/8/1999  added to do relaxations.
  int relax_ion(const Control &cntrl);
  
};


#endif // DFT_IONDYNINFO_H
