/*------------------------  Elecinfo  -----------------------------------*
 *                                                                       *
 * Structure containing the information describing the electronic states *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Elecinfo.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_ELECINFO_H
#define DFT_ELECINFO_H

class Elecinfo
{
public:
  real Ecut;         /* Energy cutoff in Hartrees */
  int nkpts,nbands;  /* Number of bands and number of k-points */
  real nelectrons;   /* the number of electrons; normally the total sum
		      * of all the fillings*weights */
  vector3 *kvec;     /* the k-vectors for the k-points */
  real *w;           /* the weights of the k-points */
  diag_matrix *F;    /* the fillings for each k-point */
  int calc_fillings; /* 1 or 0 flag: whether fillings must be calculated */
  real kT;           /* Temperature for Fermi distribution of fillings */
  real mu;           /* Chemical potential for Fermi fillings */
  int niter_recalc_fillings; /* we recalc. fillings every so many iterations */

  /* The below are for the subspace rotation variables */
  int subspace_rotation;    /* flag for subspace rotations. */
  real pcond_for_Bgrad;  /* preconditioning number for Bgrad if 
			    subspace_rotation is enabled.
			    Default is 30.0 */
  int ex_opt;  /* This switch is to select 
		  exchange-correlation functionals.
	          DFT_EXCORR_LDA for LDA,  DFT_EXCORR_GGA  for GGA */

  /* The two below specify how initial fillings of bands are calculated */
  int initial_fillings_flag; /* 0 = calculate fillings automatically */
                             /* 1 = read initial fillings from file */
  char initial_fillings_filename[DFT_FILENAME_LEN];

  int nl_core_flag;  /* If this flag is set, perform non-linear core correction */


  Elecinfo();
  void print() const;
  void setup_initial_fillings(Basis *basis);
  void print_fillings(Output *out) const;
};

#endif // DFT_ELECINFO_H
