/*--------------------------  symm.c  -----------------------------------*
 *                                                                       *
 * Calculates the symmetries of the system,                              *
 *                                                                       *
 * Fold and reduce the k-points.                                         *
 *                                                                       *
 * And symmetrize the charge density.                                    *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: symm.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_SYMM_H
#define DFT_SYMM_H

void symmetries(Ioninfo *ioninfo, Basis *basis);
void bravais_symmetries(Basis *basis, int &bnrot, matrix3 *bsym);
void minimize_basis(matrix3 &a, matrix3 &t);
real matcmp(matrix3 a, matrix3 b);
void basis_symmetries(Ioninfo *ioninfo, int &bnrot, matrix3 *bsym, 
		      vector3 tr, int &tnrot, matrix3 *tsym);
void check_symmetries(Ioninfo *ioninfo);
void fold_kpoints(vector3** kvec, real **w, const int* kpt_fold,int &nkpts);
void reduce_kpoints(const vector3 *kvec, real *w, const Ioninfo &ioninfo,
		    Elecinfo &elecinfo, const Basis &basis,
		    int reduce_kpts_flag);
int check_symm_fftbox(Ioninfo &ioninfo, const Basis &basis);
int symmetrize_n(vector & n, int nrot, const matrix3 * n_sym, int * done);

#endif // DFT_SYMM_H
