/*-----------------------  setup_elecs.c  -------------------------------*
 *                                                                       *
 * Read electronic infomation from a file and setup the data structure   *
 * containing the information (fillings, weights, kpoints, etc.)         *
 * Allocate/free space for and initialize the electronic variables       *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: setup_elecs.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_SETUP_ELECS_H
#define DFT_SETUP_ELECS_H

void setup_elecinfo(Elecinfo *elecs,char *elecfilename,
		    Basis **basis, Control &cntrl);
void free_elecinfo(Elecinfo *elecs);
void init_elecvars(Elecinfo *efino,Basis *basis,Elecvars *evars);
void free_elecvars(Elecinfo *einfo,Elecvars *evars);

#endif // DFT_SETUP_ELECS_H
