/*--------------------------  setup.c  ----------------------------------*
 *                                                                       *
 * A new centralized setup file that uses free format key-value inputs,  *
 *  aimed at replacing all individual setup files' input routines        *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: setup.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_SETUP_H
#define DFT_SETUP_H

void parse_command_line(int argc, char **argv, 
			char *input_filename,
			char *logfilename);
void setup(dft_text_FILE *filep, Parameters &params,
	   Elecinfo &elecinfo, Basis** basis, IonDyninfo &iondyninfo,
	   Control &cntrl);
int prepare_wavefunctions(Parameters &params,
			  Elecinfo &elecinfo, Elecvars &elecvars,
			  IonDyninfo &iondyninfo);
void print_template(Parameters &params,
		    const Elecinfo &elecinfo, Basis *basis,
		    const IonDyninfo &iondyninfo,
		    const Control &cntrl);

#endif // DFT_SETUP_H
