/*------------------------  minimize.c  ---------------------------------*
 *                                                                       *
 * Does minimization of energy versus electronic degrees of freedom.     *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: minimize.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_MINIMIZE_H
#define DFT_MINIMIZE_H

void calc_UVCn_d_elec_dependent_energies(Basis *basis,
					 Ioninfo *ioninfo,
					 Elecinfo *einfo,Elecvars *elecvars,
					 Energies *ener);
void calc_UVCn_d(Elecinfo *einfo,Elecvars *evars);
void calc_UVCn_d_Hsub_fillings(Elecinfo *elecinfo,Elecvars *elecvars,
			       Ioninfo *ioninfo);
void copy_C_to_Y(Elecinfo *elecinfo,Elecvars *elecvars);
void set_Y_to_Hsub_eigenbasis(Elecinfo *elecinfo,Elecvars *elecvars,
			      Ioninfo *ioninfo);
real do_linmin(column_bundle *dir,
	       Basis *basis,
	       Ioninfo *ioninfo,
	       Elecinfo *einfo,Elecvars *evars,
	       Energies *ener0,
	       column_bundle *grad,
	       real stepsize);  /* returns stepsize used */
real minimize_elec_cg(Basis *basis,
		      Ioninfo *ioninfo,
		      Elecinfo *elecinfo,
		      Elecvars *elecvars,
		      Energies *ener,
		      Control &cntrl);
real minimize_elec_cg_nocosgg(Basis *basis,
			      Ioninfo *ioninfo,
			      Elecinfo *elecinfo,
			      Elecvars *elecvars,
			      Energies *ener,
			      Control &cntrl);
real minimize_elec_pcg(Basis *basis,
		       Ioninfo *ioninfo,
		       Elecinfo *elecinfo,
		       Elecvars *elecvars,
		       Energies *ener,
		       Control &cntrl);
real minimize_elec_pcg_nocosgpg(Basis *basis,
				Ioninfo *ioninfo,
				Elecinfo *elecinfo,
				Elecvars *elecvars,
				Energies *ener,
				Control &cntrl);
real minimize_elec_eom(Basis *basis,
		       Ioninfo *ioninfo,
		       Elecinfo *elecinfo,
		       Elecvars *elecvars,
		       Energies *ener,
		       Control &cntrl);
real minimize_elec_psd(Basis *basis,
		       Ioninfo *ioninfo,
		       Elecinfo *elecinfo,
		       Elecvars *elecvars,
		       Energies *ener,
		       Control &cntrl);

#endif // DFT_MINIMIZE_H
