/****************************************************************************
 *
 * DFT++:  density functional package developed by
 *         the research group of Prof. Tomas Arias, MIT.
 *
 * Principal author: Sohrab Ismail-Beigi
 *
 * Modifications for MPI version: Kenneth P Esler,
 *                                Sohrab Ismail-Beigi, and
 *                                Tairan Wang.
 *
 * Modifications for LSD version: Jason A Cline
 *
 * Modifications for lattice/Pulay forces: Gabor Csanyi and
 *                                         Sohrab Ismail-Beigi
 *
 * Copyright (C) 1996-1998 The Massachusetts Institute of Technology (MIT).
 *
 ****************************************************************************/

/*
 * diag_matrix.C
 *
 */

/* $Id: diag_matrix.c,v 1.1.1.1 1999/11/10 01:30:17 tairan Exp $ */

#include <stdio.h>
#include <math.h>

#include "header.h"

/* default constructor */
diag_matrix::diag_matrix()
{
  n = 0; c = 0; basis = 0;
}

/* constructor with given size:  allocate the memory! */
diag_matrix::diag_matrix(int len)
{
  c = (scalar *)mymalloc(sizeof(scalar)*len,"c","diag_matrix(int)");
  n = len; basis = 0;
}

/* constructor with given size and basis pointer */
diag_matrix::diag_matrix(int len,Basis *b)
{
  c = (scalar *)mymalloc(sizeof(scalar)*len,
			 "c","diag_matrix(int,Basis *)");
  n = len;
  basis = b;
}

/* Copy constructor */
diag_matrix::diag_matrix(const diag_matrix &d1)
{
  int i;

  n = d1.n;
  c = (scalar *)mymalloc(sizeof(scalar)*n,"c","diag_matrix copy constructor");
  for (i=0; i < d1.n; i++)
    c[i] = d1.c[i];
  basis = d1.basis;
}

/* desctructor */
diag_matrix::~diag_matrix()
{
  myfree(c);
}

/* Assignment:  nonstandard in that it returns void.  To make it standard,
 * replace void -> diag_matrix and uncomment the return *this; */
void diag_matrix::operator=(const diag_matrix &d1)
{
  int i;

  /* The sizes must agree */
  if (n != d1.n)
    die("in diag_matrix::operator=, n != d1.n\n");
  for (i=0; i < d1.n; i++)
    c[i] = d1.c[i];
  basis = d1.basis;
  /* return *this; */
}

/* Does what the constructor does as a member function */
void diag_matrix::init(int len,Basis *b)
{
  c = (scalar *)mymalloc(sizeof(scalar)*len,"c","diag_matrix.init");
  n = len;
  basis = b;
}


void diag_matrix::print() const
{
  int i;

  for (i=0; i < n; i++)
    {
#if defined SCALAR_IS_COMPLEX
      dft_log("%lg%+lgi ",c[i].x,c[i].y);
#elif defined SCALAR_IS_REAL
      dft_log("%lg ",c[i]);
#else
#error scalar is neither real nor complex!
#endif
    }
  dft_log("\n");
}

/* zeroes our the diagonal matrix */
void diag_matrix::zero_out(void)
{
  int i;
  for (i=0; i < n; i++)
    c[i] = (scalar)0.0;
}
