/*-------------------------  calcener.c  --------------------------------*
 *                                                                       *
 * Calculate all the various energy terms in various combinations        *
 * All these energy routines simply take what is given to them in        *
 * as inputs and calculate the corresponding energies; i.e. none of      *
 * of the contents of the inputs are changed.  For example the local     *
 * pseudopot. energy does NOT calculate the local pseudopotential and    *
 * the Hartree energy does NOT solve the poisson equation.               *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: calcener.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_CALCENER_H
#define DFT_CALCENER_H

void calc_KE(Elecinfo *einfo,Elecvars *evars,
	     Energies *ener);
void calc_Eloc(Elecvars *evars,      
	       Energies *ener);   /* Local pseudopot energy */
void calc_Enl(Basis *basis,
	      Ioninfo *ioninfo,
	      Elecinfo *einfo,Elecvars *evars,
	      Energies *ener);    /* Non-local pseudopot energy */
void calc_EH(Elecvars *evars,
	     Energies *ener);  /* Hartree energy */
void calc_Exc(Elecvars *evars,
	      Energies *ener);
void calc_Ecore(Ioninfo *ioninfo,
		Basis *basis,
		Elecinfo *einfo,Energies *ener);
void calc_Eewald(Ioninfo *ioninfo,
		 Basis *basis,
		 Energies *ener);
void calc_Epulay(Ioninfo *ioninfo,
		 Elecinfo *einfo,
		 Basis *basis,
		 Energies *ener);
void calc_Etot(Energies *ener); /* adds up all the energies into ener->Etot */
void calc_F(Elecinfo *einfo,Energies *ener); /* Helmholtz free energy */
void calc_all_energies(Basis *basis,
		       Ioninfo *ioninfo,
		       Elecinfo *einfo,Elecvars *evars,
		       Energies *ener);
void calc_elec_dependent_energies(Basis *basis,
				  Ioninfo *ioninfo,
				  Elecinfo *einfo,Elecvars *evars,
				  Energies *ener);
void calc_core_ewald_pulay_energies(Basis *basis,
				    Ioninfo *ioninfo,
				    Elecinfo *einfo,
				    Energies *ener);
void print_energies(Elecinfo *einfo,Energies *ener, Output *out);

#endif // DFT_CALCENER_H
