/*-------------------------  Ioninfo  -----------------------------------*
 * Master structure containing info on all ions                          *
 * (Member functions in setup_ions.c)                                    *
 *-----------------------------------------------------------------------*/

/* $Id: Ioninfo.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_IONINFO_H
#define DFT_IONINFO_H


class Ioninfo
{
public:
  int nspecies;
  Speciesinfo *species;

  /* 
   * the new feature: symmetries.   Nikolaj Moll  Apr 3 1999
   * Need to think about where to put this eventually. This seems an awkward 
   * place to put it.
   * 
   * nrot  is the total number of symmetries of the system.
   * sym[] contains the symmetry matrices in relative real-space coordinates.
   * n_sym[] is the corresponding symmetry matrices for charge density mesh,
   *      i.e. the rescaling of mesh-density is included. It is initialized in
   *      check_symm_fftbox.
   * done[0:n.n-1] is a temporary array used for symmetry calculation
   */
  int nrot, *done;
  matrix3 sym[48], n_sym[48];

  // Maxim : 11/1/99. Line constraints in ion dynamics.
  int number_of_line_constraints;
  vector3 *line_constraint_direction,*line_constraint_forces;
  int *line_constraint_n_sp,*line_constraint_n_at;

  /* constructor */
  Ioninfo() {
    nspecies = 0;
    nrot = 0;
    number_of_line_constraints = 0;
  }

  /*
   * Member functions:
   */
  void print() const;
  void check_pos();  // make sure no ions are on top of each other.

  // Maxim added on 11/1/99, subroutine used by IonDyninfo.c needed to check
  // whether an atom [at] of species [sp] is constrained to move along a line.
  int check_line_constraint(int sp, int at) const;
  void constrain_forces_to_lines();
  void print_force(const matrix3 &RRT) const;
};

#endif // DFT_IONINFO_H
