/*---------------------------  Basis  -----------------------------------*
 *                                                                       *
 * Master structure defining the basis set used for the calculation      *
 *  One Basis object each is needed for every k-point.                   *
 *  And an additional Basis object is used for charge-density-FFT.       *
 *                                                                       *
 * (operated on in setup.c , setup_basis.c)                              *
 *                                                                       *
 *-----------------------------------------------------------------------*/

/* $Id: Basis.h,v 1.2 1999/11/11 02:40:31 tairan Exp $ */

#ifndef DFT_BASIS_H
#define DFT_BASIS_H

class Basis
{
public:
  /* lattice vectors (in the columns) & det(latvec) */
  matrix3 latvec;
  real unit_cell_volume;

  /* G = reciprocal lat. vecs in row. G*GT = G*G^T where T = transpose,
   * so GGT is the matrix of recip. lat. vec. dot products */
  matrix3 G,GGT;

  int Nx,Ny,Nz,NxNyNz;  /* grid sizes for FFT box and the product */

  /* Minimum and maximum values of each G-direction (inclusive) */
  int Gxmin,Gxmax,Gymin,Gymax,Gzmin,Gzmax;

  int nbasis; /* number of basis elements (i.e. G-vectors) */
  int *Gx,*Gy,*Gz; /* the G-vectors for the basis in recip. lattice coords */
  int *index; /* indices of the basis functions in the FFT boxes used */

  Basis() { latvec.m[0][0] = latvec.m[0][1] = latvec.m[0][2] =
            latvec.m[1][0] = latvec.m[1][1] = latvec.m[1][2] =
            latvec.m[2][0] = latvec.m[2][1] = latvec.m[2][2] = 0.0;
            Gx = Gy = Gz = NULL; index = NULL; }
  ~Basis() { ; }

  /* calculate unit_cell_volume, G,GGT and such given latvec */
  void init(real Ecut, int Nx_spec, int Ny_spec, int Nz_spec);
  void init2(const Basis &b, const vector3 &kvec, 
	     real Ecut, real &G2max);
  void init2(const Basis &b);
};

#endif // DFT_BASIS_H
